(********************************************************************
 * PROGRAM: Lika
 * File: Lika.st
 * Author: Roberto Baricca
 * Created: August 04, 2015
 ********************************************************************
 * Implementation of program Lika
 ********************************************************************)

PROGRAM _CYCLIC

	
	//Calcola differenza quote
	CheckQuote.QuotaAttuale:=Position;
	CheckQuote.DifferenzaQuota:=UDINT_TO_DINT(CheckQuote.QuotaAttuale)-UDINT_TO_DINT(CheckQuote.QuotaPrecedente);

	//Controlla "differenza quota" > "soglia sup"
	IF (CheckQuote.DifferenzaQuota>=CheckQuote.SogliaErroreSup) THEN
		CheckQuote.Bit_SuperataSogliaSup:=TRUE;
	ELSE
		CheckQuote.Bit_SuperataSogliaSup:=FALSE;
	END_IF

	//Controlla "differenza quota" < "soglia inf"
	IF (CheckQuote.DifferenzaQuota<=CheckQuote.SogliaErroreInf) THEN
		CheckQuote.Bit_SuperataSogliaInf:=TRUE;
	ELSE
		CheckQuote.Bit_SuperataSogliaInf:=FALSE;
	END_IF
	
	//Verifica errore	
	IF CheckQuote.Bit_SuperataSogliaSup OR  CheckQuote.Bit_SuperataSogliaInf THEN
		//ERRORE
		CheckQuote.QuotaAttualeLatchError:=CheckQuote.QuotaAttuale;
		CheckQuote.QuotaPrecLatchError:=CheckQuote.QuotaPrecedente;
		CheckQuote.DifferenzaQuotaError:=CheckQuote.DifferenzaQuota;
		CheckQuote.NumCicliErrore:=CheckQuote.NumCicliErrore+1;
	ELSE
		
	END_IF

	CheckQuote.QuotaPrecedente:=CheckQuote.QuotaAttuale;

END_PROGRAM
