(********************************************************************
 * PROGRAM: Lika
 * File: Lika.st
 * Author: Roberto Baricca
 * Created: August 04, 2015
 ********************************************************************
 * Implementation of program Lika
 ********************************************************************)

PROGRAM _CYCLIC
//	RETURN;  //ATTENZIONE : UN SOLO PROGRAMMA PUO' ESSERE ABILITATO ALLA VOLTA

	Enc_Position:=Position;
	
	IF GlobalError=1 THEN 
		RETURN;
	END_IF
	
	IF Write_bit_save_par=FALSE THEN
		RETURN;  
	END_IF	
	
	CASE epl.state OF 	
	
		EPL_WAIT:  (*state to wait for user Commands*)
			epl.state := EPL_WRITE_OE;   
		EPL_WRITE_OE:  
			
			IF(CodeSequence = FALSE) THEN
				LIKA_OBJ.OperatingParameter_6000_0 := LIKA_OBJ.OperatingParameter_6000_0 AND 16#FFFE;
			ELSE
				LIKA_OBJ.OperatingParameter_6000_0 := LIKA_OBJ.OperatingParameter_6000_0 OR 16#0001;
			END_IF
			
			IF (bit_save_par = TRUE) THEN
				LIKA_OBJ.OperatingParameter_6000_0 := LIKA_OBJ.OperatingParameter_6000_0 OR 16#8000;
			ELSE
				LIKA_OBJ.OperatingParameter_6000_0 := LIKA_OBJ.OperatingParameter_6000_0 AND 16#7FFF;			
			END_IF
			
				
			
			//==================== WRITE OBJECT ENTRY ========================
			epl.fub.EplSDOWrite_0.enable := 1;  (*enable the FUB*)
			epl.fub.EplSDOWrite_0.pDevice := ADR('IF3');  (*Device Name of Powerlink interface*)
			epl.fub.EplSDOWrite_0.node := 1;  (*Node Number of the Station to be read*)
			epl.fub.EplSDOWrite_0.index := 16#6000;  (*Write index *)
			epl.fub.EplSDOWrite_0.subindex := 0;  (*Subindex *)
			epl.fub.EplSDOWrite_0.pData:=ADR(LIKA_OBJ.OperatingParameter_6000_0);(*pointer to the variable to be read*)
			epl.fub.EplSDOWrite_0.datalen:=SIZEOF(LIKA_OBJ.OperatingParameter_6000_0);(*Length of the Data to be read*)
			
			IF epl.fub.EplSDOWrite_0.status = 0 THEN  
				(*writing successful*)	
				Write_bit_save_par:=FALSE;
				epl.state := EPL_WAIT;
				epl.fub.EplSDOWrite_0.enable := 0;  (*disable the FUB*)	
				NumCycleWrite:=NumCycleWrite+1;
			ELSIF epl.fub.EplSDOWrite_0.status = ERR_FUB_BUSY THEN  
				(*Busy*)
			ELSIF epl.fub.EplSDOWrite_0.status = ERR_FUB_ENABLE_FALSE THEN  
				(*FUB is disabled*)
			ELSE  (*Go to error Step*)
				epl.state := EPL_ERROR;				
			END_IF
		EPL_ERROR:  
			(* Here some error Handling has to be implemented *)
			GlobalError:=1;
	END_CASE;	
	
	epl.fub.EplSDOWrite_0();  (*Call the EplSDOWrite_0 FUB*)

END_PROGRAM
