
TYPE
	eplCmd_typ : 	STRUCT  (*datatype with commands*)
		read : {REDUND_UNREPLICABLE} BOOL; (*command to read the Node Number of the Powerlink interface*)
		write : BOOL; (*command to write an Object Entry*)
	END_STRUCT;
	S_LIKA_OBJ : 	STRUCT 
		SpeedFormat_2002_0 : UINT;
		NodeID_2100_0 : USINT;
		HMS_SN_2101_0 : UDINT;
		FW_Version_HI_2102_0 : USINT;
		FW_Version_LOW_2103_0 : USINT;
		FW_Version_BUILD_2104_0 : USINT;
		OperatingParameter_6000_0 : UINT;
		MeasuringUnitsPerRev_6001_0 : UDINT;
		TotalMeasuringRange_6002_0 : UDINT;
		PresetValue_6003_0 : DINT;
		PositionValue_6004_0 : UDINT;
		SpeedValue_6030_0 : UDINT;
		OperatingStatus_6500_0 : UINT;
		SingleturnResolution_6501_0 : UDINT;
		NumberOfRevolution_6502_0 : UINT;
		Alarms_6503_0 : UINT;
		SupportedAlarms_6504_0 : UINT;
		SupportedWarnings_6506_0 : UINT;
		ProfileAndSoftwareVersion_6507_0 : UDINT;
		OperatingTime_6508_0 : UDINT;
		OffsetValue_6509_0 : DINT;
		SerialNumber_650B_0 : UDINT;
	END_STRUCT;
	epl_typ : 	STRUCT  (*datatype for AsEPL Library*)
		cmd : eplCmd_typ; (*variable with commands*)
		para : eplPara_typ; (*variable with parameters*)
		fub : eplFUB_typ; (*variable with Function Blocks*)
		state : state_enum; (*variable with actual state*)
	END_STRUCT;
	eplPara_typ : 	STRUCT  (*datatype with parameters*)
		nodeNr : {REDUND_UNREPLICABLE} USINT; (*Node number of the Powerling interface*)
		index : UINT;
		subindex : USINT;
		readData : UDINT; (*Read Data*)
		readLen : UDINT; (*Data to be written*)
		writeData : UDINT; (*Data to be written*)
		writeLen : UDINT; (*Data to be written*)
	END_STRUCT;
	state_enum : 
		( (*enumerators for the state in the task*)
		EPL_WAIT, (*state to wait for any commands*)
		EPL_READ_OE, (*state to read object entry*)
		EPL_WRITE_OE, (*state to write object entry*)
		EPL_ERROR (*state when an error occured*)
		);
	SCheckQuote : 	STRUCT 
		QuotaAttuale : UDINT; (*Posizione attuale*)
		QuotaPrecedente : UDINT; (*Posizione precedente*)
		DifferenzaQuota : DINT; (*Posizione precedente*)
		QuotaAttualeLatchError : UDINT; (*Quota attuale in caso di errore*)
		QuotaPrecLatchError : UDINT; (*Quota precedente in caso di errore*)
		DifferenzaQuotaError : DINT; (*Differenza quota in caso di errore*)
		NumCicliErrore : UINT; (*Numero cicli di errore*)
		Bit_SuperataSogliaSup : BOOL; (*bit superamento soglia superiore*)
		Bit_SuperataSogliaInf : BOOL; (*bit superamento soglia inferiore*)
		SogliaErroreSup : DINT := 256; (*Soglia di errore superiore*)
		SogliaErroreInf : DINT := -256; (*Soglia di errore inferiore*)
	END_STRUCT;
	S_U64 : 	STRUCT 
		UDINT_LOW : UDINT;
		UDINT_HIGH : UDINT;
	END_STRUCT;
	S_OCTET_STRING8 : 	STRUCT 
		BYTE_0 : USINT;
		BYTE_1 : USINT;
		BYTE_2 : USINT;
		BYTE_3 : USINT;
		BYTE_4 : USINT;
		BYTE_5 : USINT;
		BYTE_6 : USINT;
		BYTE_7 : USINT;
	END_STRUCT;
	eplFUB_typ : 	STRUCT  (*datatype with Function Blocks*)
		EplSDOWrite_0 : EplSDOWrite; (*FUB to write a node's object entries*)
		EplSDORead_0 : EplSDORead; (*FUB to read a node's object entries*)
	END_STRUCT;
	S_LIKA_ProfileArea : 	STRUCT 
		DeviceType_U32_1000_0 : UDINT;
		ERR_ErrorRegister_U8_1001_00 : USINT;
		NMT_CycleLen_U32_1006_0 : UDINT;
		NMT_ManufactDevName_VS_1008_0 : STRING[80];
		NMT_ManufactHwVers_VS_1009_00 : STRING[80];
		NMT_ManufactSwVers_VS_100A_0 : STRING[80];
		NMT_IdentityObject_REC_1018_0 : USINT;
		NMT_IdentityObject_REC_1018_1 : UDINT;
		NMT_IdentityObject_REC_1018_2 : UDINT;
		NMT_IdentityObject_REC_1018_3 : UDINT;
		NMT_IdentityObject_REC_1018_4 : UDINT;
		CFM_VerifyConfig_REC_1020_0 : USINT;
		CFM_VerifyConfig_REC_1020_1 : UDINT;
		CFM_VerifyConfig_REC_1020_2 : UDINT;
		NMT_InterfaceDescription_1030_0 : USINT;
		NMT_InterfaceDescription_1030_1 : UINT;
		NMT_InterfaceDescription_1030_2 : STRING[80];
		NMT_InterfaceDescription_1030_3 : USINT;
		NMT_InterfaceDescription_1030_4 : UINT;
		NMT_InterfaceDescription_1030_5 : S_OCTET_STRING8;
		NMT_InterfaceDescription_1030_6 : STRING[11];
		NMT_InterfaceDescription_1030_7 : USINT;
		NMT_InterfaceDescription_1030_8 : USINT;
		NMT_InterfaceDescription_1030_9 : USINT;
		SDO_SequLayerTimeout_1300_0 : UDINT;
		PDO_RxCommParam_00_REC_1400_0 : USINT;
		PDO_RxCommParam_00_REC_1400_1 : USINT;
		PDO_RxCommParam_00_REC_1400_2 : USINT;
		PDO_RxMappParam_00h_1600_0 : USINT;
		PDO_RxMappParam_00h_1600_1 : S_U64;
		PDO_TxCommParam_00_REC_1800_0 : UDINT;
		PDO_TxCommParam_00_REC_1800_1 : UDINT;
		PDO_TxCommParam_00_REC_1800_2 : UDINT;
		PDO_TxMappParam_00h_1A00_0 : USINT;
		PDO_TxMappParam_00h_1A00_1 : S_U64;
		PDO_TxMappParam_00h_1A00_2 : S_U64;
		DLL_CNLossSoc_1C0B_0 : USINT;
		DLL_CNLossSoc_1C0B_1 : UDINT;
		DLL_CNLossSoc_1C0B_2 : UDINT;
		DLL_CNLossSoc_1C0B_3 : UDINT;
		DLL_CNCError_1C0F_0 : USINT;
		DLL_CNCError_1C0F_1 : UDINT;
		DLL_CNCError_1C0F_2 : UDINT;
		DLL_CNCError_1C0F_3 : UDINT;
		DLL_CNLossOfSocTol_1C14_0 : UDINT;
		NMT_NodeAssignment_1F81_0 : USINT;
		NMT_NodeAssignment_1F81_1 : UDINT;
		NMT_FeatureFlags_1F82_0 : UDINT;
		NMT_EPLVersion_1F83_0 : USINT;
		NMT_CurrNMTState_1F8C_0 : USINT;
		NMT_EPLNODEID_1F93_0 : USINT;
		NMT_EPLNODEID_1F93_1 : USINT;
		NMT_EPLNODEID_1F93_2 : BOOL;
		NMT_CycleTiming_1F98_0 : USINT;
		NMT_CycleTiming_1F98_1 : UINT;
		NMT_CycleTiming_1F98_2 : UINT;
		NMT_CycleTiming_1F98_3 : UDINT;
		NMT_CycleTiming_1F98_4 : UINT;
		NMT_CycleTiming_1F98_5 : UINT;
		NMT_CycleTiming_1F98_6 : UDINT;
		NMT_CycleTiming_1F98_7 : USINT;
		NMT_CycleTiming_1F98_8 : UINT;
		NMT_CNBasicEthTimeout_1F99_0 : UDINT;
		NMT_MultipCycleAssign_1F9B_0 : USINT;
		NMT_MultipCycleAssign_1F9B_1 : USINT;
		NMT_ResetCmd_1F9E_0 : USINT;
	END_STRUCT;
END_TYPE
