(********************************************************************
 * PROGRAM: Lika
 * File: Lika.st
 * Author: Roberto Baricca
 * Created: August 04, 2015
 ********************************************************************
 * Implementation of program Lika
 ********************************************************************)

PROGRAM _CYCLIC

	IF Read_DipSwitchNode=0 THEN 
		RETURN;
	END_IF

	IF GlobalError=1 THEN 
		RETURN;
	END_IF
	
	IF epl.state=EPL_WAIT THEN

		//=================== READ ALL MANUFACTURER PARAMETER ==========================
		IF Read_DipSwitchNode THEN
			epl.para.nodeNr:=1;
			epl.cmd.read:=1;epl.cmd.write:=0;
			Index:=16#2100;SubIndex:=0;
		END_IF
		
	END_IF	
	
 
	//
	epl.para.index:=Index;
	epl.para.subindex:=SubIndex;
	
	//================================================

		CASE epl.state OF 	
	
			EPL_WAIT:  (*state to wait for user Commands*)
			
			IF (epl.cmd.read = 1) THEN  (*check for command to read object entry*)
				epl.cmd.read := 0;  (*reset command*)
				epl.state := EPL_READ_OE;  (*jump to READ_OE state*)
				
			ELSIF (epl.cmd.write = 1) THEN  (*check for command to write object entry*)
				epl.cmd.write := 0;  (*reset command*)
				epl.state := EPL_WRITE_OE;  (*jump to WRITE_OE state*)
				
			END_IF

		EPL_READ_OE:   
			//==================== READ OBJECT ENTRY ========================

			epl.fub.EplSDORead_0.enable := 1;  (*enable the FUB*)
			epl.fub.EplSDORead_0.pDevice := ADR('IF3');  (*Device Name of Powerlink interface*)
  			epl.fub.EplSDORead_0.node := epl.para.nodeNr;  (*Node Number of the Station to be read*)
			epl.fub.EplSDORead_0.index := epl.para.index;  (*Read Index *)
			epl.fub.EplSDORead_0.subindex := epl.para.subindex;  (*Subindex *)
			CASE  Index OF
				16#2100:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.NodeID_2100_0);(*pointer to the variable to be read*)
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.NodeID_2100_0);(*Length of the Data to be read*)
			END_CASE
			
			IF epl.fub.EplSDORead_0.status = 0 THEN  (*reading successful*)	
				epl.state := EPL_WAIT;
				epl.fub.EplSDORead_0.enable := 0;  (*disable the FUB*)	
				NumCycleRead:=NumCycleRead+1;
				DipSwitchNode:=LIKA_OBJ.NodeID_2100_0;
			ELSIF epl.fub.EplSDORead_0.status = ERR_FUB_BUSY THEN  (*reading not finished --> do again*)
				(*Busy*)
			ELSIF epl.fub.EplSDORead_0.status = ERR_FUB_ENABLE_FALSE THEN  (*FUB is disabled*)
				(*Disabled*)				
			ELSE  (*Go to error Step*)
				epl.state := EPL_ERROR;				
			END_IF

		EPL_ERROR:  (*State when an error occured*)
			(* Here some error Handling has to be implemented *)
			GlobalError:=1;
	
	END_CASE;	
	
	epl.fub.EplSDORead_0();  (*Call the EplSDORead_0 FUB*)

END_PROGRAM
