(********************************************************************
 * PROGRAM: Lika
 * File: Lika.st
 * Author: Roberto Baricca
 * Created: August 04, 2015
 ********************************************************************
 * Implementation of program Lika
 ********************************************************************)

PROGRAM _CYCLIC

	IF Read_All_Man_Param=0 THEN 
		RETURN;
	END_IF

	IF GlobalError=1 THEN 
		RETURN;
	END_IF
	
	IF epl.state=EPL_WAIT THEN

		//=================== READ ALL MANUFACTURER PARAMETER ==========================
		IF Read_All_Man_Param THEN
			epl.para.nodeNr:=1;
			epl.cmd.read:=1;epl.cmd.write:=0;
			IF AsyncFaseCiclo=0 THEN
				AsyncFaseCiclo:=1;
				Index:=16#2002;SubIndex:=0;
			END_IF
		END_IF
		
		//=================== WRITE ONE MANUFACTURER PARAMETER ==========================
		IF Write THEN
			epl.para.nodeNr:=1;
			epl.cmd.read:=0;epl.cmd.write:=1;
		END_IF
	END_IF	
	
 
	//
	epl.para.index:=Index;
	epl.para.subindex:=SubIndex;
	
	//================================================

		CASE epl.state OF 	
	
			EPL_WAIT:  (*state to wait for user Commands*)
			
			IF (epl.cmd.read = 1) THEN  (*check for command to read object entry*)
				epl.cmd.read := 0;  (*reset command*)
				epl.state := EPL_READ_OE;  (*jump to READ_OE state*)
				
			ELSIF (epl.cmd.write = 1) THEN  (*check for command to write object entry*)
				epl.cmd.write := 0;  (*reset command*)
				epl.state := EPL_WRITE_OE;  (*jump to WRITE_OE state*)
				
			END_IF

		EPL_READ_OE:   
			//==================== READ OBJECT ENTRY ========================

			epl.fub.EplSDORead_0.enable := 1;  (*enable the FUB*)
			epl.fub.EplSDORead_0.pDevice := ADR('IF3');  (*Device Name of Powerlink interface*)
  			epl.fub.EplSDORead_0.node := epl.para.nodeNr;  (*Node Number of the Station to be read*)
			epl.fub.EplSDORead_0.index := epl.para.index;  (*Read Index *)
			epl.fub.EplSDORead_0.subindex := epl.para.subindex;  (*Subindex *)
			CASE  Index OF
				16#2002:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.SpeedFormat_2002_0);(*pointer to the variable to be read*)
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.SpeedFormat_2002_0);(*Length of the Data to be read*)
				16#2100:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.NodeID_2100_0);(*pointer to the variable to be read*)
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.NodeID_2100_0);(*Length of the Data to be read*)
				16#2101:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.HMS_SN_2101_0);(*pointer to the variable to be read*)
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.HMS_SN_2101_0);(*Length of the Data to be read*)
				16#2102:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.FW_Version_HI_2102_0);(*pointer to the variable to be read*)
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.FW_Version_HI_2102_0);(*Length of the Data to be read*)
				16#2103:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.FW_Version_LOW_2103_0);(*pointer to the variable to be read*)
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.FW_Version_LOW_2103_0);(*Length of the Data to be read*)
				16#2104:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.FW_Version_BUILD_2104_0);(*pointer to the variable to be read*)
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.FW_Version_BUILD_2104_0);(*Length of the Data to be read*)
				16#6000:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.OperatingParameter_6000_0);(*pointer to the variable to be read*)
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.OperatingParameter_6000_0);(*Length of the Data to be read*)
				16#6001:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.MeasuringUnitsPerRev_6001_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.MeasuringUnitsPerRev_6001_0);(*Length of the Data to be read*)
				16#6002:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.TotalMeasuringRange_6002_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.TotalMeasuringRange_6002_0);(*Length of the Data to be read*)
				16#6003:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.PresetValue_6003_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.PresetValue_6003_0);(*Length of the Data to be read*)
				16#6004:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.PositionValue_6004_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.PositionValue_6004_0);(*Length of the Data to be read*)
				16#6030:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.SpeedValue_6030_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.SpeedValue_6030_0);(*Length of the Data to be read*)
				16#6500:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.OperatingStatus_6500_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.OperatingStatus_6500_0);(*Length of the Data to be read*)
				16#6501:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.SingleturnResolution_6501_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.SingleturnResolution_6501_0);(*Length of the Data to be read*)
				16#6502:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.NumberOfRevolution_6502_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.NumberOfRevolution_6502_0);(*Length of the Data to be read*)
				16#6503:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.Alarms_6503_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.Alarms_6503_0);(*Length of the Data to be read*)
				16#6504:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.SupportedAlarms_6504_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.SupportedAlarms_6504_0);(*Length of the Data to be read*)
				16#6506:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.SupportedWarnings_6506_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.SupportedWarnings_6506_0);(*Length of the Data to be read*)
				16#6507:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.ProfileAndSoftwareVersion_6507_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.ProfileAndSoftwareVersion_6507_0);(*Length of the Data to be read*)
				16#6508:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.OperatingTime_6508_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.OperatingTime_6508_0);(*Length of the Data to be read*)
				16#6509:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.OffsetValue_6509_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.OffsetValue_6509_0);(*Length of the Data to be read*)
				16#650B:
					epl.fub.EplSDORead_0.pData:=ADR(LIKA_OBJ.SerialNumber_650B_0);
					epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_OBJ.SerialNumber_650B_0);(*Length of the Data to be read*)
			END_CASE
			
			IF epl.fub.EplSDORead_0.status = 0 THEN  (*reading successful*)	
				epl.state := EPL_WAIT;
				epl.fub.EplSDORead_0.enable := 0;  (*disable the FUB*)	
				NumCycleRead:=NumCycleRead+1;
				
				//READ NEXT INDEX
				CASE  Index OF
					16#2002:Index:=16#2100;SubIndex:=0;
					16#2100:Index:=16#2101;SubIndex:=0;
					16#2101:Index:=16#2102;SubIndex:=0;
					16#2102:Index:=16#2103;SubIndex:=0;
					16#2103:Index:=16#2104;SubIndex:=0;
					16#2104:Index:=16#6000;SubIndex:=0;
					16#6000:Index:=16#6001;SubIndex:=0;
					16#6001:Index:=16#6002;SubIndex:=0;
					16#6002:Index:=16#6003;SubIndex:=0;
					16#6003:Index:=16#6004;SubIndex:=0;
					16#6004:Index:=16#6030;SubIndex:=0;
					16#6030:Index:=16#6500;SubIndex:=0;
					16#6500:Index:=16#6501;SubIndex:=0;
					16#6501:Index:=16#6502;SubIndex:=0;
					16#6502:Index:=16#6503;SubIndex:=0;
					16#6503:Index:=16#6504;SubIndex:=0;
					16#6504:Index:=16#6506;SubIndex:=0;
					16#6506:Index:=16#6507;SubIndex:=0;
					16#6507:Index:=16#6508;SubIndex:=0;
					16#6508:Index:=16#6509;SubIndex:=0;
					16#6509:Index:=16#650B;SubIndex:=0;
					16#650B:
							//end
							Read_All_Man_Param:=0;
							AsyncFaseCiclo:=0;
				END_CASE

			ELSIF epl.fub.EplSDORead_0.status = ERR_FUB_BUSY THEN  (*reading not finished --> do again*)
				(*Busy*)
			ELSIF epl.fub.EplSDORead_0.status = ERR_FUB_ENABLE_FALSE THEN  (*FUB is disabled*)
				(*Disabled*)				
			ELSE  (*Go to error Step*)
				epl.state := EPL_ERROR;				
			END_IF


		EPL_WRITE_OE:  
		//==================== WRITE OBJECT ENTRY ========================
			epl.fub.EplSDOWrite_0.enable := 1;  (*enable the FUB*)
			epl.fub.EplSDOWrite_0.pDevice := ADR('IF3');  (*Device Name of Powerlink interface*)
			epl.fub.EplSDOWrite_0.node := epl.para.nodeNr;  (*Node Number of the Station to be read*)
			epl.fub.EplSDOWrite_0.index := epl.para.index;  (*Write index *)
			epl.fub.EplSDOWrite_0.subindex := epl.para.subindex;  (*Subindex *)
			CASE  Index OF
				16#2002:
					epl.fub.EplSDOWrite_0.pData:=ADR(LIKA_OBJ.SpeedFormat_2002_0);(*pointer to the variable to be read*)
					epl.fub.EplSDOWrite_0.datalen:=SIZEOF(LIKA_OBJ.SpeedFormat_2002_0);(*Length of the Data to be read*)
				16#6000:
					epl.fub.EplSDOWrite_0.pData:=ADR(LIKA_OBJ.OperatingParameter_6000_0);(*pointer to the variable to be read*)
					epl.fub.EplSDOWrite_0.datalen:=SIZEOF(LIKA_OBJ.OperatingParameter_6000_0);(*Length of the Data to be read*)
				16#6001:
					epl.fub.EplSDOWrite_0.pData:=ADR(LIKA_OBJ.MeasuringUnitsPerRev_6001_0);(*pointer to the variable to be read*)
					epl.fub.EplSDOWrite_0.datalen:=SIZEOF(LIKA_OBJ.MeasuringUnitsPerRev_6001_0);(*Length of the Data to be read*)
				16#6002:
					epl.fub.EplSDOWrite_0.pData:=ADR(LIKA_OBJ.TotalMeasuringRange_6002_0);(*pointer to the variable to be read*)
					epl.fub.EplSDOWrite_0.datalen:=SIZEOF(LIKA_OBJ.TotalMeasuringRange_6002_0);(*Length of the Data to be read*)
				16#6003:
					epl.fub.EplSDOWrite_0.pData:=ADR(LIKA_OBJ.PresetValue_6003_0);(*pointer to the variable to be read*)
					epl.fub.EplSDOWrite_0.datalen:=SIZEOF(LIKA_OBJ.PresetValue_6003_0);(*Length of the Data to be read*)
			END_CASE
			
			IF epl.fub.EplSDOWrite_0.status = 0 THEN  (*writing successful*)	
				epl.state := EPL_WAIT;
				epl.fub.EplSDOWrite_0.enable := 0;  (*disable the FUB*)	
				NumCycleWrite:=NumCycleWrite+1;
				Write:=0;
			ELSIF epl.fub.EplSDOWrite_0.status = ERR_FUB_BUSY THEN  (*writing not finished --> do again*)
				(*Busy*)
			ELSIF epl.fub.EplSDOWrite_0.status = ERR_FUB_ENABLE_FALSE THEN  (*FUB is disabled*)
				(*Disabled*)				
			ELSE  (*Go to error Step*)
				epl.state := EPL_ERROR;				
			END_IF


		EPL_ERROR:  (*State when an error occured*)
		(* Here some error Handling has to be implemented *)
			AsyncFaseCiclo:=0;
			GlobalError:=1;
		
	
	END_CASE;	
	
	epl.fub.EplSDORead_0();  (*Call the EplSDORead_0 FUB*)
	epl.fub.EplSDOWrite_0();  (*Call the EplSDOWrite_0 FUB*)

END_PROGRAM
