(********************************************************************
 * COPYRIGHT -- Bernecker + Rainer
 ********************************************************************
 * Program: epl
 * File: eplCyclic.st
 * Author: Bernecker + Rainer
 * Created: August 04, 2009
 ********************************************************************
 * Implementation of program epl
 ********************************************************************)

PROGRAM _CYCLIC

	IF Read_Profile_Area=0 THEN 
		RETURN;
	END_IF

	IF GlobalError=1 THEN 
		RETURN;
	END_IF

	IF epl.state=EPL_WAIT THEN
		//=================== READ PROFILE AREA ==========================
		IF Read_Profile_Area THEN
			epl.para.nodeNr:=1;
			epl.cmd.read:=1;epl.cmd.write:=0;
			IF AsyncFaseCiclo=0 THEN
				AsyncFaseCiclo:=1;
				Index:=16#1000;SubIndex:=0;
			END_IF
		END_IF
	END_IF	
	
	epl.para.index:=Index;
	epl.para.subindex:=SubIndex;
	
	//================================================

	CASE epl.state OF 	
	
			EPL_WAIT:  (*state to wait for user Commands*)
			
				IF (epl.cmd.read = 1) THEN  (*check for command to read object entry*)
					epl.cmd.read := 0;  (*reset command*)
					epl.state := EPL_READ_OE;  (*jump to READ_OE state*)
				
				ELSIF (epl.cmd.write = 1) THEN  (*check for command to write object entry*)
					epl.cmd.write := 0;  (*reset command*)
					epl.state := EPL_WRITE_OE;  (*jump to WRITE_OE state*)
				
				END_IF

			EPL_READ_OE:   
				//==================== READ OBJECT ENTRY ========================
				epl.fub.EplSDORead_0.enable := 1;  (*enable the FUB*)
				epl.fub.EplSDORead_0.pDevice := ADR('IF3');  (*Device Name of Powerlink interface*)
				epl.fub.EplSDORead_0.node := epl.para.nodeNr;  (*Node Number of the Station to be read*)
				epl.fub.EplSDORead_0.index := epl.para.index;  (*Read Index *)
				epl.fub.EplSDORead_0.subindex := epl.para.subindex;  (*Subindex *)
				CASE  Index OF
					16#1000:
						epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.DeviceType_U32_1000_0);(*pointer to the variable to be read*)
						epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.DeviceType_U32_1000_0);(*Length of the Data to be read*)
					16#1001:
						epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.ERR_ErrorRegister_U8_1001_00);(*pointer to the variable to be read*)
						epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.ERR_ErrorRegister_U8_1001_00);(*Length of the Data to be read*)
					16#1006:
						epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_CycleLen_U32_1006_0);(*pointer to the variable to be read*)
						epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_CycleLen_U32_1006_0);(*Length of the Data to be read*)
					16#1008:
						epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_ManufactDevName_VS_1008_0);(*pointer to the variable to be read*)
						epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_ManufactDevName_VS_1008_0);(*Length of the Data to be read*)
					16#1009:
						epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_ManufactHwVers_VS_1009_00);(*pointer to the variable to be read*)
						epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_ManufactHwVers_VS_1009_00);(*Length of the Data to be read*)
					16#100A:
						epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_ManufactSwVers_VS_100A_0);(*pointer to the variable to be read*)
						epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_ManufactSwVers_VS_100A_0);(*Length of the Data to be read*)
					16#1018:
							CASE SubIndex OF
									0:
										epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_IdentityObject_REC_1018_0);(*pointer to the variable to be read*)
										epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_IdentityObject_REC_1018_0);(*Length of the Data to be read*)
									1:
										epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_IdentityObject_REC_1018_1);(*pointer to the variable to be read*)
										epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_IdentityObject_REC_1018_1);(*Length of the Data to be read*)
									2:
										epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_IdentityObject_REC_1018_2);(*pointer to the variable to be read*)
										epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_IdentityObject_REC_1018_2);(*Length of the Data to be read*)
									3:
										epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_IdentityObject_REC_1018_3);(*pointer to the variable to be read*)
										epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_IdentityObject_REC_1018_3);(*Length of the Data to be read*)
									4:
										epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_IdentityObject_REC_1018_4);(*pointer to the variable to be read*)
										epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_IdentityObject_REC_1018_4);(*Length of the Data to be read*)
							END_CASE
					16#1020:
						CASE SubIndex OF
									0:	epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.CFM_VerifyConfig_REC_1020_0);(*pointer to the variable to be read*)
										epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.CFM_VerifyConfig_REC_1020_0);(*Length of the Data to be read*)
									1:	epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.CFM_VerifyConfig_REC_1020_1);(*pointer to the variable to be read*)
										epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.CFM_VerifyConfig_REC_1020_1);(*Length of the Data to be read*)
									2:	epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.CFM_VerifyConfig_REC_1020_2);(*pointer to the variable to be read*)
										epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.CFM_VerifyConfig_REC_1020_2);(*Length of the Data to be read*)
						END_CASE
					16#1030:
						CASE SubIndex OF
							0:	epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_InterfaceDescription_1030_0);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_InterfaceDescription_1030_0);(*Length of the Data to be read*)
							1:	epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_InterfaceDescription_1030_1);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_InterfaceDescription_1030_1);(*Length of the Data to be read*)
							2:	epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_InterfaceDescription_1030_2);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_InterfaceDescription_1030_2);(*Length of the Data to be read*)
							3:	epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_InterfaceDescription_1030_3);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_InterfaceDescription_1030_3);(*Length of the Data to be read*)
							4:	epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_InterfaceDescription_1030_4);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_InterfaceDescription_1030_4);(*Length of the Data to be read*)
							5:	epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_InterfaceDescription_1030_5);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_InterfaceDescription_1030_5);(*Length of the Data to be read*)
							6:	epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_InterfaceDescription_1030_6);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_InterfaceDescription_1030_6);(*Length of the Data to be read*)
							7:	epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_InterfaceDescription_1030_7);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_InterfaceDescription_1030_7);(*Length of the Data to be read*)
							8:	epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_InterfaceDescription_1030_8);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_InterfaceDescription_1030_8);(*Length of the Data to be read*)
							9:	epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_InterfaceDescription_1030_9);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_InterfaceDescription_1030_9);(*Length of the Data to be read*)
						END_CASE
					16#1300:
						epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.SDO_SequLayerTimeout_1300_0);(*pointer to the variable to be read*)
						epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.SDO_SequLayerTimeout_1300_0);(*Length of the Data to be read*)
					16#1400:
						CASE SubIndex OF
							0:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.PDO_RxCommParam_00_REC_1400_0);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.PDO_RxCommParam_00_REC_1400_0);(*Length of the Data to be read*)
							1:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.PDO_RxCommParam_00_REC_1400_1);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.PDO_RxCommParam_00_REC_1400_1);(*Length of the Data to be read*)
						END_CASE
					16#1600:
						CASE SubIndex OF
							0:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.PDO_RxMappParam_00h_1600_0);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.PDO_RxMappParam_00h_1600_0);(*Length of the Data to be read*)
							1:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.PDO_RxMappParam_00h_1600_1);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.PDO_RxMappParam_00h_1600_1);(*Length of the Data to be read*)
						END_CASE
					16#1800:
						CASE SubIndex OF
							0:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.PDO_TxCommParam_00_REC_1800_0);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.PDO_TxCommParam_00_REC_1800_0);(*Length of the Data to be read*)
							1:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.PDO_TxCommParam_00_REC_1800_1);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.PDO_TxCommParam_00_REC_1800_1);(*Length of the Data to be read*)
							2:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.PDO_TxCommParam_00_REC_1800_2);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.PDO_TxCommParam_00_REC_1800_2);(*Length of the Data to be read*)
						END_CASE
					16#1A00:
						CASE SubIndex OF
							0:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.PDO_TxMappParam_00h_1A00_0);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.PDO_TxMappParam_00h_1A00_0);(*Length of the Data to be read*)
							1:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.PDO_TxMappParam_00h_1A00_1);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.PDO_TxMappParam_00h_1A00_1);(*Length of the Data to be read*)
							2:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.PDO_TxMappParam_00h_1A00_2);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.PDO_TxMappParam_00h_1A00_2);(*Length of the Data to be read*)
						END_CASE
					16#1C0B:
						CASE SubIndex OF
							0:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.DLL_CNLossSoc_1C0B_0);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.DLL_CNLossSoc_1C0B_0);(*Length of the Data to be read*)
							1:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.DLL_CNLossSoc_1C0B_1);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.DLL_CNLossSoc_1C0B_2);(*Length of the Data to be read*)
							2:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.DLL_CNLossSoc_1C0B_2);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.DLL_CNLossSoc_1C0B_2);(*Length of the Data to be read*)
							3:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.DLL_CNLossSoc_1C0B_3);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.DLL_CNLossSoc_1C0B_3);(*Length of the Data to be read*)
						END_CASE
					16#1C0F:
						CASE SubIndex OF
							0:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.DLL_CNCError_1C0F_0);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.DLL_CNCError_1C0F_0);(*Length of the Data to be read*)
							1:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.DLL_CNCError_1C0F_1);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.DLL_CNCError_1C0F_1);(*Length of the Data to be read*)
							2:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.DLL_CNCError_1C0F_2);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.DLL_CNCError_1C0F_2);(*Length of the Data to be read*)
							3:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.DLL_CNCError_1C0F_3);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.DLL_CNCError_1C0F_3);(*Length of the Data to be read*)
						END_CASE
					16#1C14:
						epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.DLL_CNLossOfSocTol_1C14_0);(*pointer to the variable to be read*)
						epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.DLL_CNLossOfSocTol_1C14_0);(*Length of the Data to be read*)
					16#1F81:
						CASE SubIndex OF
							0:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_NodeAssignment_1F81_0);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_NodeAssignment_1F81_0);(*Length of the Data to be read*)
							1:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_NodeAssignment_1F81_1);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_NodeAssignment_1F81_1);(*Length of the Data to be read*)
						END_CASE
					16#1F82:
						epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_FeatureFlags_1F82_0);(*pointer to the variable to be read*)
						epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_FeatureFlags_1F82_0);(*Length of the Data to be read*)
					16#1F83:
						epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_EPLVersion_1F83_0);(*pointer to the variable to be read*)
						epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_EPLVersion_1F83_0);(*Length of the Data to be read*)
					16#1F8C:
						epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_CurrNMTState_1F8C_0);(*pointer to the variable to be read*)
						epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_CurrNMTState_1F8C_0);(*Length of the Data to be read*)
//					16#1F8D:
//						CASE SubIndex OF
//							0:
//								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_PresPayLoad_1F8D_0);(*pointer to the variable to be read*)
//								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_PresPayLoad_1F8D_0);(*Length of the Data to be read*)
//							1:
//								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_PresPayLoad_1F8D_1);(*pointer to the variable to be read*)
//								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_PresPayLoad_1F8D_1);(*Length of the Data to be read*)
//						END_CASE
					16#1F93:
						CASE SubIndex OF
							0:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_EPLNODEID_1F93_0);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_EPLNODEID_1F93_0);(*Length of the Data to be read*)
							1:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_EPLNODEID_1F93_1);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_EPLNODEID_1F93_1);(*Length of the Data to be read*)
							2:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_EPLNODEID_1F93_2);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_EPLNODEID_1F93_2);(*Length of the Data to be read*)
						END_CASE
					16#1F98:
						CASE SubIndex OF
							0:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_CycleTiming_1F98_0);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_CycleTiming_1F98_0);(*Length of the Data to be read*)
							1:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_CycleTiming_1F98_1);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_CycleTiming_1F98_1);(*Length of the Data to be read*)
							2:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_CycleTiming_1F98_2);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_CycleTiming_1F98_2);(*Length of the Data to be read*)
							3:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_CycleTiming_1F98_3);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_CycleTiming_1F98_3);(*Length of the Data to be read*)
							4:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_CycleTiming_1F98_4);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_CycleTiming_1F98_4);(*Length of the Data to be read*)
							5:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_CycleTiming_1F98_5);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_CycleTiming_1F98_5);(*Length of the Data to be read*)
							6:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_CycleTiming_1F98_6);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_CycleTiming_1F98_6);(*Length of the Data to be read*)
							7:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_CycleTiming_1F98_7);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_CycleTiming_1F98_7);(*Length of the Data to be read*)
							8:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_CycleTiming_1F98_8);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_CycleTiming_1F98_8);(*Length of the Data to be read*)
						END_CASE
					16#1F99:
						epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_CNBasicEthTimeout_1F99_0);(*pointer to the variable to be read*)
						epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_CNBasicEthTimeout_1F99_0);(*Length of the Data to be read*)
					16#1F9B:
						CASE SubIndex OF
							0:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_MultipCycleAssign_1F9B_0);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_MultipCycleAssign_1F9B_0);(*Length of the Data to be read*)
							1:
								epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_MultipCycleAssign_1F9B_1);(*pointer to the variable to be read*)
								epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_MultipCycleAssign_1F9B_1);(*Length of the Data to be read*)
						END_CASE
					16#1F9E:
						epl.fub.EplSDORead_0.pData:=ADR(LIKA_ProfileArea.NMT_ResetCmd_1F9E_0);(*pointer to the variable to be read*)
						epl.fub.EplSDORead_0.datalen:=SIZEOF(LIKA_ProfileArea.NMT_ResetCmd_1F9E_0);(*Length of the Data to be read*)
			END_CASE
			
			IF epl.fub.EplSDORead_0.status = 0 THEN  (*reading successful*)	
					epl.state := EPL_WAIT;
					epl.fub.EplSDORead_0.enable := 0;  (*disable the FUB*)	
					NumCycleRead:=NumCycleRead+1;
				
					//READ NEXT INDEX
					CASE  Index OF
						16#1000:Index:=16#1001;SubIndex:=0;
						16#1001:Index:=16#1006;SubIndex:=0;
						16#1006:Index:=16#1008;SubIndex:=0;
						16#1008:Index:=16#1009;SubIndex:=0;
						16#1009:Index:=16#100A;SubIndex:=0;
						16#100A:Index:=16#1018;SubIndex:=0;
						16#1018:
							CASE SubIndex OF
								0:SubIndex:=1;
								1:SubIndex:=2;
								2:SubIndex:=3;
								3:SubIndex:=4;
								4:Index:=16#1020;SubIndex:=0; 
							END_CASE
						16#1020:
							CASE SubIndex OF
								0:SubIndex:=1;
								1:SubIndex:=2;
								2:Index:=16#1030;SubIndex:=0;
							END_CASE
						16#1030:
							CASE SubIndex OF
								0:SubIndex:=1;
								1:SubIndex:=2;
								2:SubIndex:=3;
								3:SubIndex:=4;
								4:SubIndex:=5;
								5:SubIndex:=6;
								6:SubIndex:=7;
								7:SubIndex:=8;
								8:SubIndex:=9;
								9:Index:=16#1300;SubIndex:=0;
							END_CASE
						16#1300:Index:=16#1400;SubIndex:=0;
						16#1400:
							CASE SubIndex OF
								0:SubIndex:=1;
								1:SubIndex:=2;
								2:Index:=16#1600;SubIndex:=0;
							END_CASE
						16#1600:
							CASE SubIndex OF
								0:SubIndex:=1;
								1:Index:=16#1800;SubIndex:=0;
							END_CASE
						16#1800:
							CASE SubIndex OF
								0:SubIndex:=1;
								1:SubIndex:=2;
								2:Index:=16#1A00;SubIndex:=0; 
							END_CASE
						16#1A00:
							CASE SubIndex OF
								0:SubIndex:=1;
								1:SubIndex:=2; 
								2:Index:=16#1C0B;SubIndex:=0;
							END_CASE
						16#1C0B:
							CASE SubIndex OF
								0:SubIndex:=1;
								1:SubIndex:=2;
								2:SubIndex:=3;
								3:Index:=16#1C0F;SubIndex:=0; 
							END_CASE
						16#1C0F:
							CASE SubIndex OF
								0:SubIndex:=1;
								1:SubIndex:=2;
								2:SubIndex:=3;
								3:Index:=16#1C14;SubIndex:=0; 
							END_CASE
						16#1C14:Index:=16#1F81;SubIndex:=0; 
						16#1F81:
							CASE SubIndex OF
							0:SubIndex:=1;
							1:Index:=16#1F82;SubIndex:=0; 
							END_CASE
						16#1F82:Index:=16#1F83;SubIndex:=0;
						16#1F83:Index:=16#1F8C;SubIndex:=0;
						//16#1F8C:Index:=16#1F8D;SubIndex:=0;
						16#1F8C:Index:=16#1F93;SubIndex:=0;
//						16#1F8D:
//							CASE SubIndex OF
//								0:SubIndex:=1;
//								1:Index:=16#1F93;SubIndex:=0; 
//							END_CASE
						16#1F93:
							CASE SubIndex OF
								0:SubIndex:=1;
								1:SubIndex:=2;
								2:Index:=16#1F98;SubIndex:=0; 
							END_CASE
						16#1F98:
							CASE SubIndex OF
								0:SubIndex:=1;
								1:SubIndex:=2;
								2:SubIndex:=3;
								3:SubIndex:=4;
								4:SubIndex:=5;
								5:SubIndex:=6;
								6:SubIndex:=7;
								7:SubIndex:=8;
								8:Index:=16#1F99;SubIndex:=0; 
							END_CASE
						16#1F99:Index:=16#1F9B;SubIndex:=0;
						16#1F9B:
							CASE SubIndex OF
								0:SubIndex:=1;
								1:Index:=16#1F9E;SubIndex:=0; 
							END_CASE
						16#1F9E://
								//end
								AsyncFaseCiclo:=0;
								Read_Profile_Area:=0;
				END_CASE
			ELSIF epl.fub.EplSDORead_0.status = ERR_FUB_BUSY THEN  (*reading not finished --> do again*)
					(*Busy*)
				ELSIF epl.fub.EplSDORead_0.status = ERR_FUB_ENABLE_FALSE THEN  (*FUB is disabled*)
					(*Disabled*)				
				ELSE  (*Go to error Step*)
					epl.state := EPL_ERROR;				
				END_IF



			EPL_ERROR:  (*State when an error occured*)
				(* Here some error Handling has to be implemented *)
				AsyncFaseCiclo:=0;
				GlobalError:=1;
	
	
	END_CASE	
	
		epl.fub.EplSDORead_0();  (*Call the EplSDORead_0 FUB*)
		epl.fub.EplSDOWrite_0();  (*Call the EplSDOWrite_0 FUB*)
		
		END_PROGRAM

